#ifndef __FCNTL_H__
#define __FCNTL_H__
/* Copyright (C) 1991-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
/*
 *	POSIX Standard: 6.5 File Control Operations	<fcntl.h>
 */
#define _FCNTL_H 1
/* This must be early so <bits/fcntl.h> can define types winningly.  */
__BEGIN_DECLS
/* Get __mode_t, __dev_t and __off_t  .*/
/* Get the definitions of O_*, F_*, FD_*: all the
   numbers and flag bits for `open', `fcntl', et al.  */
#include <bits/fcntl.h>
/* Detect if open needs mode as a third argument (or for openat as a fourth
   argument).  */
#define __OPEN_NEEDS_MODE(oflag) (((oflag) & O_CREAT) != 0 || ((oflag) & __O_TMPFILE) == __O_TMPFILE)
/* POSIX.1-2001 specifies that these types are defined by <fcntl.h>.
   Earlier POSIX standards permitted any type ending in `_t' to be defined
   by any POSIX header, so we don't conditionalize the definitions here.  */
typedef __mode_t mode_t;
#define __mode_t_defined 
/* For XPG all symbols from <sys/stat.h> should also be available.  */
#include <types/struct_timespec.h>
#include <bits/stat.h>
#define S_IFMT __S_IFMT
#define S_IFDIR __S_IFDIR
#define S_IFCHR __S_IFCHR
#define S_IFBLK __S_IFBLK
#define S_IFREG __S_IFREG
#define S_IFIFO __S_IFIFO
#define S_IFLNK __S_IFLNK
#define S_IFSOCK __S_IFSOCK
/* Protection bits.  */
#define S_ISUID __S_ISUID
#define S_ISGID __S_ISGID
/* Save swapped text after use (sticky bit).  This is pretty well obsolete.  */
#define S_ISVTX __S_ISVTX
#define S_IRUSR __S_IREAD
#define S_IWUSR __S_IWRITE
#define S_IXUSR __S_IEXEC
/* Read, write, and execute by owner.  */
#define S_IRWXU (__S_IREAD|__S_IWRITE|__S_IEXEC)
#define S_IRGRP (S_IRUSR >> 3)
#define S_IWGRP (S_IWUSR >> 3)
#define S_IXGRP (S_IXUSR >> 3)
/* Read, write, and execute by group.  */
#define S_IRWXG (S_IRWXU >> 3)
#define S_IROTH (S_IRGRP >> 3)
#define S_IWOTH (S_IWGRP >> 3)
#define S_IXOTH (S_IXGRP >> 3)
/* Read, write, and execute by others.  */
#define S_IRWXO (S_IRWXG >> 3)
/* XPG wants the following symbols.   <stdio.h> has the same definitions.  */
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
/* Do the file control operation described by CMD on FD.
   The remaining arguments are interpreted depending on CMD.
   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int __REDIRECT (fcntl, (int __fd, int __cmd, ...), fcntl64);
extern int fcntl64 (int __fd, int __cmd, ...);
/* Open FILE and return a new file descriptor for it, or -1 on error.
   OFLAG determines the type of access used.  If O_CREAT or O_TMPFILE is set
   in OFLAG, the third argument is taken as a `mode_t', the mode of the
   created file.
   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int __REDIRECT (open, (const char *__file, int __oflag, ...), open64)
     __nonnull ((1));
extern int open64 (const char *__file, int __oflag, ...) __nonnull ((1));
/* Similar to `open' but a relative path name is interpreted relative to
   the directory for which FD is a descriptor.
   NOTE: some other `openat' implementation support additional functionality
   through this interface, especially using the O_XATTR flag.  This is not
   yet supported here.
   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int __REDIRECT (openat, (int __fd, const char *__file, int __oflag,
				...), openat64) __nonnull ((2));
extern int openat64 (int __fd, const char *__file, int __oflag, ...)
     __nonnull ((2));
/* Create and open FILE, with mode MODE.  This takes an `int' MODE
   argument because that is what `mode_t' will be widened to.
   This function is a cancellation point and therefore not marked with
   __THROW.  */
extern int __REDIRECT (creat, (const char *__file, mode_t __mode),
		       creat64) __nonnull ((1));
extern int creat64 (const char *__file, mode_t __mode) __nonnull ((1));
/* Advice the system about the expected behaviour of the application with
   respect to the file associated with FD.  */
 
extern int __REDIRECT_NTH (posix_fadvise, (int __fd, __off64_t __offset,
					   __off64_t __len, int __advise),
			   posix_fadvise64);
extern int posix_fadvise64 (int __fd, off64_t __offset, off64_t __len,
			    int __advise) __THROW;
/* Reserve storage for the data of the file associated with FD.
   This function is a possible cancellation point and therefore not
   marked with __THROW.  */
 
extern int __REDIRECT (posix_fallocate, (int __fd, __off64_t __offset,
					 __off64_t __len),
		       posix_fallocate64);
extern int posix_fallocate64 (int __fd, off64_t __offset, off64_t __len);
/* Define some inlines helping to catch common problems.  */
__END_DECLS
#endif /* __FCNTL_H__ */
