#ifndef __STATX_GENERIC_H__
#define __STATX_GENERIC_H__
/* Generic statx-related definitions and declarations.
   Copyright (C) 2018-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
/* This interface is based on <linux/stat.h> in Linux.  */
#include <types/struct_statx_timestamp.h>
#include <types/struct_statx.h>
__BEGIN_DECLS
/* Fill *BUF with information about PATH in DIRFD.  */
int statx (int __dirfd, const char *__restrict __path, int __flags,
           unsigned int __mask, struct statx *__restrict __buf)
  __THROW __nonnull ((2, 5));
__END_DECLS
#endif /* __STATX_GENERIC_H__ */
