#ifndef __STATFS_H__
#define __STATFS_H__
/* Definitions for getting information about a filesystem.
   Copyright (C) 1996-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
#define _SYS_STATFS_H 1
/* Get the system-specific definition of `struct statfs'.  */
#include <bits/statfs.h>
__BEGIN_DECLS
/* Return information about the filesystem on which FILE resides.  */
extern int __REDIRECT_NTH (statfs,
			   (const char *__file, struct statfs *__buf),
			   statfs64) __nonnull ((1, 2));
extern int statfs64 (const char *__file, struct statfs64 *__buf)
     __THROW __nonnull ((1, 2));
/* Return information about the filesystem containing the file FILDES
   refers to.  */
extern int __REDIRECT_NTH (fstatfs, (int __fildes, struct statfs *__buf),
			   fstatfs64) __nonnull ((2));
extern int fstatfs64 (int __fildes, struct statfs64 *__buf)
     __THROW __nonnull ((2));
__END_DECLS
#endif /* __STATFS_H__ */
