#ifndef __TYPES_H__
#define __TYPES_H__
/* Copyright (C) 1991-2020 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.
   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.
   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, see
   <https://www.gnu.org/licenses/>.  */
/*
 *	POSIX Standard: 2.6 Primitive System Data Types	<sys/types.h>
 */
#define _SYS_TYPES_H 1
__BEGIN_DECLS
typedef __u_char u_char;
typedef __u_short u_short;
typedef __u_int u_int;
typedef __u_long u_long;
typedef __quad_t quad_t;
typedef __u_quad_t u_quad_t;
typedef __fsid_t fsid_t;
#define __u_char_defined 
typedef __loff_t loff_t;
typedef __dev_t dev_t;
#define __dev_t_defined 
typedef __nlink_t nlink_t;
#define __nlink_t_defined 
typedef __id_t id_t;
#define __id_t_defined 
typedef __daddr_t daddr_t;
typedef __caddr_t caddr_t;
#define __daddr_t_defined 
typedef __key_t key_t;
#define __key_t_defined 
#include <types/clock_t.h>
#include <types/clockid_t.h>
#include <types/time_t.h>
#include <types/timer_t.h>
typedef __suseconds_t suseconds_t;
#define __suseconds_t_defined 
#define __need_size_t 
#include <stddef.h>
/* Old compatibility names for C types.  */
typedef unsigned long int ulong;
typedef unsigned short int ushort;
typedef unsigned int uint;
/* These size-specific names are used by some of the inet code.  */
/* These were defined by ISO C without the first `_'.  */
typedef __uint8_t u_int8_t;
typedef __uint16_t u_int16_t;
typedef __uint32_t u_int32_t;
typedef __uint64_t u_int64_t;
typedef int register_t __attribute__ ((__mode__ (__word__)));
/* Some code from BIND tests this macro to see if the types above are
   defined.  */
#define __BIT_TYPES_DEFINED__ 1
/* In BSD <sys/types.h> is expected to define BYTE_ORDER.  */
/* It also defines `fd_set' and the FD_* macros for `select'.  */
#include <sys/select.h>
typedef __blksize_t blksize_t;
#define __blksize_t_defined 
/* Types from the Large File Support interface.  */
typedef __blkcnt64_t blkcnt_t;	   /* Type to count number of disk blocks.  */
#define __blkcnt_t_defined 
typedef __fsblkcnt64_t fsblkcnt_t; /* Type to count file system blocks.  */
#define __fsblkcnt_t_defined 
typedef __fsfilcnt64_t fsfilcnt_t; /* Type to count file system inodes.  */
#define __fsfilcnt_t_defined 
typedef __blkcnt64_t blkcnt64_t;     /* Type to count number of disk blocks. */
typedef __fsblkcnt64_t fsblkcnt64_t; /* Type to count file system blocks.  */
typedef __fsfilcnt64_t fsfilcnt64_t; /* Type to count file system inodes.  */
/* Now add the thread types.  */
#include <bits/pthreadtypes.h>
__END_DECLS
#endif /* __TYPES_H__ */
