#ifndef __PLATFORM_H__
#define __PLATFORM_H__
/* vi: set sw=4 ts=4: */
/*
 * Copyright 2006, Bernhard Reutner-Fischer
 *
 * Licensed under GPLv2 or later, see file LICENSE in this source tree.
 */
#define BB_PLATFORM_H 1
/* Convenience macros to test the version of gcc. */
#undef __GNUC_PREREQ
#define __GNUC_PREREQ(maj,min) ((__GNUC__ << 16) + __GNUC_MINOR__ >= ((maj) << 16) + (min))
/* __restrict is known in EGCS 1.2 and above. */
#undef inline
/* it's a keyword */
#define __const const
#define UNUSED_PARAM __attribute__ ((__unused__))
#define NORETURN __attribute__ ((__noreturn__))
#define bb_unreachable(altcode) __builtin_unreachable()
/* "The malloc attribute is used to tell the compiler that a function
 * may be treated as if any non-NULL pointer it returns cannot alias
 * any other pointer valid when the function returns. This will often
 * improve optimization. Standard functions with this property include
 * malloc and calloc. realloc-like functions have this property as long
 * as the old pointer is never referred to (including comparing it
 * to the new pointer) after the function returns a non-NULL value."
 */
#define RETURNS_MALLOC __attribute__ ((malloc))
#define PACKED __attribute__ ((__packed__))
#define ALIGNED(m) __attribute__ ((__aligned__(m)))
/* __NO_INLINE__: some gcc's do not honor inlining! :( */
#define ALWAYS_INLINE inline
#define NOINLINE 
#define DEPRECATED 
#define UNUSED_PARAM_RESULT 
/* used by unit test machinery to run registration functions before calling main() */
#define INIT_FUNC __attribute__ ((constructor))
/* -fwhole-program makes all symbols local. The attribute externally_visible
 * forces a symbol global.  */
#define EXTERNALLY_VISIBLE __attribute__(( visibility("default") ))
//__attribute__ ((__externally_visible__))
/* At 4.4 gcc become much more anal about this, need to use "aliased" types */
#define FIX_ALIASING __attribute__((__may_alias__))
/* We use __extension__ in some places to suppress -pedantic warnings
 * about GCC extensions.  This feature didn't work properly before
 * gcc 2.8.  */
/* FAST_FUNC is a qualifier which (possibly) makes function call faster
 * and/or smaller by using modified ABI. It is usually only needed
 * on non-static, busybox internal functions. Recent versions of gcc
 * optimize statics automatically. FAST_FUNC on static is required
 * only if you need to match a function pointer's type.
 * FAST_FUNC may not work well with -flto so allow user to disable this.
 * (-DFAST_FUNC= )
 */
#define FAST_FUNC 
/* Make all declarations hidden (-fvisibility flag only affects definitions) */
/* (don't include system headers after this until corresponding pop!) */
#define PUSH_AND_SET_FUNCTION_VISIBILITY_TO_HIDDEN _Pragma("GCC visibility push(hidden)")
#define POP_SAVED_FUNCTION_VISIBILITY _Pragma("GCC visibility pop")
/* gcc-2.95 had no va_copy but only __va_copy. */
/* ---- Endian Detection ------------------------------------ */
#include <limits.h>
#include <byteswap.h>
#include <endian.h>
#define BB_BIG_ENDIAN 0
#define BB_LITTLE_ENDIAN 1
/* inline 64-bit bswap only on 64-bit arches */
#define bb_bswap_64(x) bswap_64(x)
/* SWAP_LEnn means "convert CPU<->little_endian by swapping bytes" */
#define SWAP_BE16(x) bswap_16(x)
#define SWAP_BE32(x) bswap_32(x)
#define SWAP_BE64(x) bb_bswap_64(x)
#define SWAP_LE16(x) (x)
#define SWAP_LE32(x) (x)
#define SWAP_LE64(x) (x)
#define IF_BIG_ENDIAN(...) 
#define IF_LITTLE_ENDIAN(...) __VA_ARGS__
/* ---- Unaligned access ------------------------------------ */
#include <stdint.h>
typedef int      bb__aliased_int      FIX_ALIASING;
typedef long     bb__aliased_long     FIX_ALIASING;
typedef uint16_t bb__aliased_uint16_t FIX_ALIASING;
typedef uint32_t bb__aliased_uint32_t FIX_ALIASING;
typedef uint64_t bb__aliased_uint64_t FIX_ALIASING;
/* NB: unaligned parameter should be a pointer, aligned one -
 * a lvalue. This makes it more likely to not swap them by mistake
 */
#define BB_UNALIGNED_MEMACCESS_OK 1
#define move_from_unaligned_int(v,intp) ((v) = *(bb__aliased_int*)(intp))
#define move_from_unaligned_long(v,longp) ((v) = *(bb__aliased_long*)(longp))
#define move_from_unaligned16(v,u16p) ((v) = *(bb__aliased_uint16_t*)(u16p))
#define move_from_unaligned32(v,u32p) ((v) = *(bb__aliased_uint32_t*)(u32p))
#define move_from_unaligned64(v,u64p) ((v) = *(bb__aliased_uint64_t*)(u64p))
#define move_to_unaligned16(u16p,v) (*(bb__aliased_uint16_t*)(u16p) = (v))
#define move_to_unaligned32(u32p,v) (*(bb__aliased_uint32_t*)(u32p) = (v))
#define move_to_unaligned64(u64p,v) (*(bb__aliased_uint64_t*)(u64p) = (v))
/* #elif ... - add your favorite arch today! */
/* Unaligned, fixed-endian accessors */
#define get_unaligned_le32(buf) ({ uint32_t v; move_from_unaligned32(v, buf); SWAP_LE32(v); })
#define get_unaligned_be32(buf) ({ uint32_t v; move_from_unaligned32(v, buf); SWAP_BE32(v); })
#define put_unaligned_le32(val,buf) move_to_unaligned32(buf, SWAP_LE32(val))
#define put_unaligned_be32(val,buf) move_to_unaligned32(buf, SWAP_BE32(val))
/* unxz needs an aligned fixed-endian accessor.
 * (however, the compiler does not realize it's aligned, the cast is still necessary)
 */
#define get_le32(u32p) ({ uint32_t v = *(bb__aliased_uint32_t*)(u32p); SWAP_LE32(v); })
/* ---- Size-saving "small" ints (arch-dependent) ----------- */
/* add other arches which benefit from this... */
typedef signed char smallint;
typedef unsigned char smalluint;
/* ISO C Standard:  7.16  Boolean type and values  <stdbool.h> */
/* modern system, so use it */
#include <stdbool.h>
/*----- Kernel versioning ------------------------------------*/
#define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#define UCLIBC_VERSION 0
/* ---- Miscellaneous --------------------------------------- */
/* Define bb_setpgrp */
#define bb_setpgrp() setpgrp()
/* fdprintf is more readable, we used it before dprintf was standardized */
#include <unistd.h>
#define fdprintf dprintf
/* Useful for defeating gcc's alignment of "char message[]"-like data */
    /* on s390[x], non-word-aligned data accesses require larger code */
#define ALIGN1 __attribute__((aligned(1)))
#define ALIGN2 __attribute__((aligned(2)))
#define ALIGN4 __attribute__((aligned(4)))
#define ALIGN8 __attribute__((aligned(8)))
#define ALIGN_INT __attribute__((aligned(sizeof(int))))
#define ALIGN_PTR __attribute__((aligned(sizeof(void*))))
/*
 * For 0.9.29 and svn, __ARCH_USE_MMU__ indicates no-mmu reliably.
 * For earlier versions there is no reliable way to check if we are building
 * for a mmu-less system.
 */
#define BB_MMU 1
#define USE_FOR_NOMMU(...) 
#define USE_FOR_MMU(...) __VA_ARGS__
/* ---- Who misses what? ------------------------------------ */
/* Assume all these functions and header files exist by default.
 * Platforms where it is not true will #undef them below.
 */
#define HAVE_CLEARENV 1
#define HAVE_FDATASYNC 1
#define HAVE_DPRINTF 1
#define HAVE_MEMRCHR 1
#define HAVE_MKDTEMP 1
#define HAVE_TTYNAME_R 1
#define HAVE_PTSNAME_R 1
#define HAVE_SETBIT 1
#define HAVE_SIGHANDLER_T 1
#define HAVE_STPCPY 1
#define HAVE_STPNCPY 1
#define HAVE_MEMPCPY 1
#define HAVE_STRCASESTR 1
#define HAVE_STRCHRNUL 1
#define HAVE_STRSEP 1
#define HAVE_STRSIGNAL 1
#define HAVE_STRVERSCMP 1
#define HAVE_VASPRINTF 1
#define HAVE_USLEEP 1
#define HAVE_UNLOCKED_STDIO 1
#define HAVE_UNLOCKED_LINE_OPS 1
#define HAVE_GETLINE 1
#define HAVE_XTABS 1
#define HAVE_MNTENT_H 1
#define HAVE_NET_ETHERNET_H 1
#define HAVE_SYS_STATFS_H 1
#define HAVE_PRINTF_PERCENTM 1
#define HAVE_WAIT3 1
#define HAVE_DEV_FD 1
#define DEV_FD_PREFIX "/dev/fd/"
/* These BSD-derived OSes share many similarities */
/*
 * Now, define prototypes for all the functions defined in platform.c
 * These must come after all the HAVE_* macros are defined (or not)
 */
#endif /* __PLATFORM_H__ */
