/*
 * Copyright (C) 2017 Denys Vlasenko <vda.linux@googlemail.com>
 *
 * Licensed under GPLv2, see file LICENSE in this source tree.
 */
//kbuild:lib-y += isqrt.o
#include "libbb.h"
/* Returns such x that x+1 > sqrt(N) */
unsigned long FAST_FUNC isqrt(unsigned long long N)
{
	unsigned long x;
	unsigned shift;
#define LL_WIDTH_BITS (unsigned)(sizeof(N)*8)
	shift = LL_WIDTH_BITS - 2;
	x = 0;
	do {
		x = (x << 1) + 1;
		if ((unsigned long long)x * x > (N >> shift))
			x--; /* whoops, that +1 was too much */
		shift -= 2;
	} while ((int)shift >= 0);
	return x;
}
