/* vi: set sw=4 ts=4: */
/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 *
 * Authors: Alexey Kuznetsov, <kuznet@ms2.inr.ac.ru>
 */
#include <sys/socket.h>
#include <arpa/inet.h>
#include <linux/if_arp.h>
#include "libbb.h"
#include "rt_names.h"
const char* FAST_FUNC ll_type_n2a(int type, char *buf)
{
	static const char arphrd_name[] ALIGN1 =
	/* 0,                  */ "generic" "\0"
	/* ARPHRD_LOOPBACK,    */ "loopback" "\0"
	/* ARPHRD_ETHER,       */ "ether" "\0"
	/* ARPHRD_INFINIBAND,  */ "infiniband" "\0"
	/* ARPHRD_IEEE802,     */ "ieee802" "\0"
	/* ARPHRD_IEEE802_TR,  */ "tr" "\0"
	/* ARPHRD_IEEE80211,   */ "ieee802.11" "\0"
	/* ARPHRD_IEEE1394,    */ "ieee1394" "\0"
	/* ARPHRD_IRDA,        */ "irda" "\0"
	/* ARPHRD_SLIP,        */ "slip" "\0"
	/* ARPHRD_CSLIP,       */ "cslip" "\0"
	/* ARPHRD_SLIP6,       */ "slip6" "\0"
	/* ARPHRD_CSLIP6,      */ "cslip6" "\0"
	/* ARPHRD_PPP,         */ "ppp" "\0"
	/* ARPHRD_TUNNEL,      */ "ipip" "\0"
	/* ARPHRD_TUNNEL6,     */ "tunnel6" "\0"
	/* ARPHRD_SIT,         */ "sit" "\0"
	/* ARPHRD_IPGRE,       */ "gre" "\0"
	/* ARPHRD_VOID,        */ "void" "\0"
	;
	/* Keep these arrays in sync! */
	static const uint16_t arphrd_type[] ALIGN2 = {
	0,                  /* "generic" "\0" */
	ARPHRD_LOOPBACK,    /* "loopback" "\0" */
	ARPHRD_ETHER,       /* "ether" "\0" */
	ARPHRD_INFINIBAND,  /* "infiniband" "\0" */
	ARPHRD_IEEE802,     /* "ieee802" "\0" */
	ARPHRD_IEEE802_TR,  /* "tr" "\0" */
	ARPHRD_IEEE80211,   /* "ieee802.11" "\0" */
	ARPHRD_IEEE1394,    /* "ieee1394" "\0" */
	ARPHRD_IRDA,        /* "irda" "\0" */
	ARPHRD_SLIP,        /* "slip" "\0" */
	ARPHRD_CSLIP,       /* "cslip" "\0" */
	ARPHRD_SLIP6,       /* "slip6" "\0" */
	ARPHRD_CSLIP6,      /* "cslip6" "\0" */
	ARPHRD_PPP,         /* "ppp" "\0" */
	ARPHRD_TUNNEL,      /* "ipip" "\0" */
	ARPHRD_TUNNEL6,     /* "tunnel6" "\0" */
	ARPHRD_SIT,         /* "sit" "\0" */
	ARPHRD_IPGRE,       /* "gre" "\0" */
	ARPHRD_VOID,        /* "void" "\0" */
	};
	unsigned i;
	const char *aname = arphrd_name;
	for (i = 0; i < ARRAY_SIZE(arphrd_type); i++) {
		if (arphrd_type[i] == type)
			return aname;
		aname += strlen(aname) + 1;
	}
	sprintf(buf, "[%d]", type);
	return buf;
}
