/*
 * Copyright (C) 2017 Denys Vlasenko
 *
 * Licensed under GPLv2, see file LICENSE in this source tree.
 */
#include "tls.h"
/* The file is taken almost verbatim from matrixssl-3-7-2b-open/crypto/math/.
 * Changes are flagged with //bbox
 */
/**
 *	@file    pstm_sqr_comba.c
 *	@version 33ef80f (HEAD, tag: MATRIXSSL-3-7-2-OPEN, tag: MATRIXSSL-3-7-2-COMM, origin/master, origin/HEAD, master)
 *
 *	Multiprecision Squaring with Comba technique.
 */
/*
 *	Copyright (c) 2013-2015 INSIDE Secure Corporation
 *	Copyright (c) PeerSec Networks, 2002-2011
 *	All Rights Reserved
 *
 *	The latest version of this code is available at http://www.matrixssl.org
 *
 *	This software is open source; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This General Public License does NOT permit incorporating this software
 *	into proprietary programs.  If you are unable to comply with the GPL, a
 *	commercial license for this software may be purchased from INSIDE at
 *	http://www.insidesecure.com/eng/Company/Locations
 *
 *	This program is distributed in WITHOUT ANY WARRANTY; without even the
 *	implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *	See the GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *	http://www.gnu.org/copyleft/gpl.html
 */
/******************************************************************************/
//bbox
//#include "../cryptoApi.h"
/******************************************************************************/
/******************************************************************************/
#define PSTM_ISO 
/* ISO C portable code */
#define COMBA_START 
#define CLEAR_CARRY c0 = c1 = c2 = 0;
#define COMBA_STORE(x) x = c0;
#define COMBA_STORE2(x) x = c1;
#define CARRY_FORWARD do { c0 = c1; c1 = c2; c2 = 0; } while (0);
#define COMBA_FINI 
/* multiplies point i and j, updates carry "c1" and digit c2 */
#define SQRADD(i,j) do { pstm_word t; t = c0 + ((pstm_word)i) * ((pstm_word)j); c0 = (pstm_digit)t; t = c1 + (t >> DIGIT_BIT); c1 = (pstm_digit)t; c2 += (pstm_digit)(t >> DIGIT_BIT); } while (0);
/* for squaring some of the terms are doubled... */
#define SQRADD2(i,j) do { pstm_word t; t = ((pstm_word)i) * ((pstm_word)j); tt = (pstm_word)c0 + t; c0 = (pstm_digit)tt; tt = (pstm_word)c1 + (tt >> DIGIT_BIT); c1 = (pstm_digit)tt; c2 += (pstm_digit)(tt >> DIGIT_BIT); tt = (pstm_word)c0 + t; c0 = (pstm_digit)tt; tt = (pstm_word)c1 + (tt >> DIGIT_BIT); c1 = (pstm_digit)tt; c2 += (pstm_digit)(tt >> DIGIT_BIT); } while (0);
#define SQRADDSC(i,j) do { pstm_word t; t = ((pstm_word)i) * ((pstm_word)j); sc0 = (pstm_digit)t; sc1 = (pstm_digit)(t >> DIGIT_BIT); sc2 = 0; } while (0);
#define SQRADDAC(i,j) do { pstm_word t; t = ((pstm_word)sc0) + ((pstm_word)i) * ((pstm_word)j); sc0 = (pstm_digit)t; t = ((pstm_word)sc1) + (t >> DIGIT_BIT); sc1 = (pstm_digit)t; sc2 += (pstm_digit)(t >> DIGIT_BIT); } while (0);
#define SQRADDDB do { pstm_word t; t = ((pstm_word)sc0) + ((pstm_word)sc0) + ((pstm_word)c0); c0 = (pstm_digit)t; t = ((pstm_word)sc1) + ((pstm_word)sc1) + c1 + (t >> DIGIT_BIT); c1 = (pstm_digit)t; c2 = c2 + sc2 + sc2 + (pstm_digit)(t >> DIGIT_BIT); } while (0);
/******************************************************************************/
/*
	Non-unrolled comba squarer
 */
//bbox: pool unused
#define pstm_sqr_comba_gen(pool,A,B,paD,paDlen) pstm_sqr_comba_gen( A, B, paD, paDlen)
static int32 pstm_sqr_comba_gen(psPool_t *pool, pstm_int *A, pstm_int *B,
			pstm_digit *paD, uint32 paDlen)
{
	int		paDfail, pa; //bbox: was int16
	int32       ix, iz;
	pstm_digit  c0, c1, c2, *dst;
	pstm_word   tt;
	paDfail = 0;
	/* get size of output and trim */
	pa = A->used + A->used;
	/* number of output digits to produce */
	COMBA_START;
	CLEAR_CARRY;
/*
	If b is not large enough grow it and continue
*/
	if (B->alloc < pa) {
		if (pstm_grow(B, pa) != PSTM_OKAY) {
			return PS_MEM_FAIL;
		}
	}
	if (paD != NULL) {
		if (paDlen < (sizeof(pstm_digit) * pa)) {
			paDfail = 1; /* have a paD, but it's not big enough */
			dst = xzalloc(sizeof(pstm_digit) * pa);//bbox
		} else {
			dst = paD;
			memset(dst, 0x0, paDlen);
		}
	} else {
		dst = xzalloc(sizeof(pstm_digit) * pa);//bbox
	}
	for (ix = 0; ix < pa; ix++) {
		int32      tx, ty, iy;
		pstm_digit *tmpy, *tmpx;
		/* get offsets into the two bignums */
		ty = min(A->used-1, ix);
		tx = ix - ty;
		/* setup temp aliases */
		tmpx = A->dp + tx;
		tmpy = A->dp + ty;
/*
			This is the number of times the loop will iterate,
				while (tx++ < a->used && ty-- >= 0) { ... }
*/
		iy = min(A->used-tx, ty+1);
/*
		now for squaring tx can never equal ty. We halve the distance since
		they approach at a rate of 2x and we have to round because odd cases
		need to be executed
*/
		iy = min(iy, (ty-tx+1)>>1);
		/* forward carries */
		CARRY_FORWARD;
		/* execute loop */
		for (iz = 0; iz < iy; iz++) {
			SQRADD2(*tmpx++, *tmpy--);
		}
		/* even columns have the square term in them */
		if ((ix&1) == 0) {
			SQRADD(A->dp[ix>>1], A->dp[ix>>1]);
		}
		/* store it */
		COMBA_STORE(dst[ix]);
	}
	COMBA_FINI;
/*
	setup dest
 */
	iz  = B->used;
	B->used = pa;
	{
		pstm_digit *tmpc;
		tmpc = B->dp;
		for (ix = 0; ix < pa; ix++) {
			*tmpc++ = dst[ix];
		}
		/*	clear unused digits (that existed in the old copy of c) */
		for (; ix < iz; ix++) {
			*tmpc++ = 0;
		}
	}
	pstm_clamp(B);
	if ((paD == NULL) || paDfail == 1) {
		psFree(dst, pool);
	}
	return PS_SUCCESS;
}
/******************************************************************************/
/*
	Unrolled Comba loop for 1024 bit keys
 */
/******************************************************************************/
/*
 */
int32 FAST_FUNC pstm_sqr_comba(psPool_t *pool, pstm_int *A, pstm_int *B, pstm_digit *paD,
		uint32 paDlen)
{
	return pstm_sqr_comba_gen(pool, A, B, paD, paDlen);
}
/******************************************************************************/
