/*
Copyright (c) 2001-2006, Gerrit Pape
All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
   1. Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. The name of the author may not be used to endorse or promote products
      derived from this software without specific prior written permission.
THIS SOFTWARE IS PROVIDED BY THE AUTHOR ''AS IS'' AND ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/* Busyboxed by Denys Vlasenko <vda.linux@googlemail.com> */
//config:config CHPST
//config:	bool "chpst (9.2 kb)"
//config:	default y
//config:	help
//config:	chpst changes the process state according to the given options, and
//config:	execs specified program.
//config:
//config:config SETUIDGID
//config:	bool "setuidgid (4.2 kb)"
//config:	default y
//config:	help
//config:	Sets soft resource limits as specified by options
//config:
//config:config ENVUIDGID
//config:	bool "envuidgid (4.1 kb)"
//config:	default y
//config:	help
//config:	Sets $UID to account's uid and $GID to account's gid
//config:
//config:config ENVDIR
//config:	bool "envdir (2.9 kb)"
//config:	default y
//config:	help
//config:	Sets various environment variables as specified by files
//config:	in the given directory
//config:
//config:config SOFTLIMIT
//config:	bool "softlimit (4.7 kb)"
//config:	default y
//config:	help
//config:	Sets soft resource limits as specified by options
//applet:IF_CHPST(    APPLET_NOEXEC(chpst,     chpst, BB_DIR_USR_BIN, BB_SUID_DROP, chpst))
//                    APPLET_NOEXEC:name       main   location        suid_type     help
//applet:IF_ENVDIR(   APPLET_NOEXEC(envdir,    chpst, BB_DIR_USR_BIN, BB_SUID_DROP, envdir))
//applet:IF_ENVUIDGID(APPLET_NOEXEC(envuidgid, chpst, BB_DIR_USR_BIN, BB_SUID_DROP, envuidgid))
//applet:IF_SETUIDGID(APPLET_NOEXEC(setuidgid, chpst, BB_DIR_USR_BIN, BB_SUID_DROP, setuidgid))
//applet:IF_SOFTLIMIT(APPLET_NOEXEC(softlimit, chpst, BB_DIR_USR_BIN, BB_SUID_DROP, softlimit))
//kbuild:lib-$(CONFIG_CHPST) += chpst.o
//kbuild:lib-$(CONFIG_ENVDIR) += chpst.o
//kbuild:lib-$(CONFIG_ENVUIDGID) += chpst.o
//kbuild:lib-$(CONFIG_SETUIDGID) += chpst.o
//kbuild:lib-$(CONFIG_SOFTLIMIT) += chpst.o
//usage:#define chpst_trivial_usage
//usage:       "[-vP012] [-u USER[:GRP]] [-U USER[:GRP]] [-e DIR]\n"
//usage:       "	[-/ DIR] [-n NICE] [-m BYTES] [-d BYTES] [-o N]\n"
//usage:       "	[-p N] [-f BYTES] [-c BYTES] PROG ARGS"
//usage:#define chpst_full_usage "\n\n"
//usage:       "Change the process state, run PROG\n"
//usage:     "\n	-u USER[:GRP]	Set uid and gid"
//usage:     "\n	-U USER[:GRP]	Set $UID and $GID in environment"
//usage:     "\n	-e DIR		Set environment variables as specified by files"
//usage:     "\n			in DIR: file=1st_line_of_file"
//usage:     "\n	-/ DIR		Chroot to DIR"
//usage:     "\n	-n NICE		Add NICE to nice value"
//usage:     "\n	-m BYTES	Same as -d BYTES -s BYTES -l BYTES"
//usage:     "\n	-d BYTES	Limit data segment"
//usage:     "\n	-o N		Limit number of open files per process"
//usage:     "\n	-p N		Limit number of processes per uid"
//usage:     "\n	-f BYTES	Limit output file sizes"
//usage:     "\n	-c BYTES	Limit core file size"
//usage:     "\n	-v		Verbose"
//usage:     "\n	-P		Create new process group"
//usage:     "\n	-0		Close stdin"
//usage:     "\n	-1		Close stdout"
//usage:     "\n	-2		Close stderr"
//usage:
//usage:#define envdir_trivial_usage
//usage:       "DIR PROG ARGS"
//usage:#define envdir_full_usage "\n\n"
//usage:       "Set various environment variables as specified by files\n"
//usage:       "in the directory DIR, run PROG"
//usage:
//usage:#define envuidgid_trivial_usage
//usage:       "USER PROG ARGS"
//usage:#define envuidgid_full_usage "\n\n"
//usage:       "Set $UID to USER's uid and $GID to USER's gid, run PROG"
//usage:
//usage:#define setuidgid_trivial_usage
//usage:       "USER PROG ARGS"
//usage:#define setuidgid_full_usage "\n\n"
//usage:       "Set uid and gid to USER's uid and gid, drop supplementary group ids,\n"
//usage:       "run PROG"
//usage:
//usage:#define softlimit_trivial_usage
//usage:       "[-a BYTES] [-m BYTES] [-d BYTES] [-s BYTES] [-l BYTES]\n"
//usage:       "	[-f BYTES] [-c BYTES] [-r BYTES] [-o N] [-p N] [-t N]\n"
//usage:       "	PROG ARGS"
//usage:#define softlimit_full_usage "\n\n"
//usage:       "Set soft resource limits, then run PROG\n"
//usage:     "\n	-a BYTES	Limit total size of all segments"
//usage:     "\n	-m BYTES	Same as -d BYTES -s BYTES -l BYTES -a BYTES"
//usage:     "\n	-d BYTES	Limit data segment"
//usage:     "\n	-s BYTES	Limit stack segment"
//usage:     "\n	-l BYTES	Limit locked memory size"
//usage:     "\n	-o N		Limit number of open files per process"
//usage:     "\n	-p N		Limit number of processes per uid"
//usage:     "\nOptions controlling file sizes:"
//usage:     "\n	-f BYTES	Limit output file sizes"
//usage:     "\n	-c BYTES	Limit core file size"
//usage:     "\nEfficiency opts:"
//usage:     "\n	-r BYTES	Limit resident set size"
//usage:     "\n	-t N		Limit CPU time, process receives"
//usage:     "\n			a SIGXCPU after N seconds"
#include "libbb.h"
/*
Five applets here: chpst, envdir, envuidgid, setuidgid, softlimit.
Only softlimit and chpst are taking options:
