/*
 * volume_id - reads filesystem label and uuid
 *
 * Copyright (C) 2005 Kay Sievers <kay.sievers@vrfy.org>
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
//kbuild:lib-$(CONFIG_VOLUMEID) += volume_id.o util.o
#include "volume_id_internal.h"
/* Some detection routines do not set label or uuid anyway,
 * so they are disabled. */
/* Looks for partitions, we don't use it: */
#define ENABLE_FEATURE_VOLUMEID_MAC 0
/* #define ENABLE_FEATURE_VOLUMEID_MSDOS      0 - NB: this one
 * was not properly added to probe table anyway - ??! */
/* None of RAIDs have label or uuid, except LinuxRAID: */
#define ENABLE_FEATURE_VOLUMEID_HIGHPOINTRAID 0
#define ENABLE_FEATURE_VOLUMEID_ISWRAID 0
#define ENABLE_FEATURE_VOLUMEID_LSIRAID 0
#define ENABLE_FEATURE_VOLUMEID_LVM 0
#define ENABLE_FEATURE_VOLUMEID_NVIDIARAID 0
#define ENABLE_FEATURE_VOLUMEID_PROMISERAID 0
#define ENABLE_FEATURE_VOLUMEID_SILICONRAID 0
#define ENABLE_FEATURE_VOLUMEID_VIARAID 0
/* These filesystems also have no label or uuid: */
#define ENABLE_FEATURE_VOLUMEID_HPFS 0
#define ENABLE_FEATURE_VOLUMEID_UFS 0
typedef int FAST_FUNC (*raid_probe_fptr)(struct volume_id *id, /*uint64_t off,*/ uint64_t size);
typedef int FAST_FUNC (*probe_fptr)(struct volume_id *id /*, uint64_t off*/);
static const raid_probe_fptr raid1[] ALIGN_PTR = {
	volume_id_probe_linux_raid,
};
static const probe_fptr raid2[] ALIGN_PTR = {
	volume_id_probe_luks,
};
/* signature in the first block, only small buffer needed */
static const probe_fptr fs1[] ALIGN_PTR = {
	volume_id_probe_vfat,
	volume_id_probe_exfat,
	volume_id_probe_lfs,
	volume_id_probe_squashfs,
	volume_id_probe_erofs,
	volume_id_probe_xfs,
	volume_id_probe_bcache,
};
/* fill buffer with maximum */
static const probe_fptr fs2[] ALIGN_PTR = {
	volume_id_probe_linux_swap,
	volume_id_probe_ext,
	volume_id_probe_btrfs,
	volume_id_probe_reiserfs,
	volume_id_probe_jfs,
	volume_id_probe_udf,
	volume_id_probe_iso9660,
	volume_id_probe_hfs_hfsplus,
	volume_id_probe_f2fs,
	volume_id_probe_nilfs,
	volume_id_probe_ntfs,
	volume_id_probe_cramfs,
	volume_id_probe_romfs,
	volume_id_probe_sysv,
	volume_id_probe_minix,
	volume_id_probe_ocfs2,
	volume_id_probe_ubifs,
};
int FAST_FUNC volume_id_probe_all(struct volume_id *id, /*uint64_t off,*/ uint64_t size)
{
	unsigned i;
	/* probe for raid first, cause fs probes may be successful on raid members */
	if (size) {
		for (i = 0; i < ARRAY_SIZE(raid1); i++) {
			if (raid1[i](id, /*off,*/ size) == 0)
				goto ret;
			if (id->error)
				goto ret;
		}
	}
	for (i = 0; i < ARRAY_SIZE(raid2); i++) {
		if (raid2[i](id /*,off*/) == 0)
			goto ret;
		if (id->error)
			goto ret;
	}
	/* signature in the first block, only small buffer needed */
	for (i = 0; i < ARRAY_SIZE(fs1); i++) {
		if (fs1[i](id /*,off*/) == 0)
			goto ret;
		if (id->error)
			goto ret;
	}
	/* fill buffer with maximum */
	volume_id_get_buffer(id, 0, SB_BUFFER_SIZE);
	for (i = 0; i < ARRAY_SIZE(fs2); i++) {
		if (fs2[i](id /*,off*/) == 0)
			goto ret;
		if (id->error)
			goto ret;
	}
 ret:
	volume_id_free_buffer(id);
	return (- id->error); /* 0 or -1 */
}
/* open volume by device node */
struct volume_id* FAST_FUNC volume_id_open_node(int fd)
{
	struct volume_id *id;
	id = xzalloc(sizeof(struct volume_id));
	id->fd = fd;
	///* close fd on device close */
	//id->fd_close = 1;
	return id;
}
void FAST_FUNC free_volume_id(struct volume_id *id)
{
	if (id == NULL)
		return;
	//if (id->fd_close != 0) - always true
		close(id->fd);
	volume_id_free_buffer(id);
	free(id);
}
